<?php
require_once 'config.php';

if (isset($_POST['save'])) {
    foreach ($_POST['set'] as $key => $val) {
        $stmt = $pdo->prepare("REPLACE INTO settings (key_name, key_value) VALUES (?, ?)");
        $stmt->execute([$key, $val]);
    }
    header("Location: admin.php?ok");
}

if (isset($_GET['reset'])) {
    $pdo->query("TRUNCATE TABLE leaderboard");
    header("Location: admin.php?resetted");
}

$rank = $pdo->query("SELECT * FROM leaderboard ORDER BY total_poin DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Balapan</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>body { background: #f4f7f6; }</style>
</head>
<body class="container py-4">
    <div class="card shadow-sm p-4 mb-4">
        <h3>Pengaturan Event</h3>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Nama Event</label>
                <input type="text" name="set[nama_event]" class="form-control" value="<?= NAMA_EVENT ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">ID Produk Peserta (Pisahkan koma)</label>
                <input type="text" name="set[produk_lomba]" class="form-control" value="<?= PRODUK_LOMBA ?>" placeholder="Contoh: 101,102,103">
                <small class="text-muted">Hanya transaksi dari ID Produk ini yang akan dihitung poinnya.</small>
            </div>
            <div class="mb-3">
                <label class="form-label">Status Event</label>
                <select name="set[event_status]" class="form-control">
                    <option value="aktif" <?= EVENT_STATUS == 'aktif' ? 'selected' : '' ?>>Aktif</option>
                    <option value="nonaktif" <?= EVENT_STATUS == 'nonaktif' ? 'selected' : '' ?>>Non-Aktif</option>
                </select>
            </div>
            <button name="save" class="btn btn-primary w-100">Simpan Pengaturan</button>
        </form>
    </div>

    <div class="card shadow-sm p-4">
        <h3>Klasemen Member 
            <a href="?reset" class="btn btn-danger btn-sm float-end" onclick="return confirm('Reset semua skor member menjadi 0?')">Reset Skor</a>
        </h3>
        <table class="table table-striped mt-3">
            <thead><tr><th>Posisi</th><th>Nama Member</th><th>ID User</th><th>Total Poin</th></tr></thead>
            <tbody>
                <?php $no=1; foreach($rank as $r): ?>
                <tr>
                    <td>#<?= $no++ ?></td>
                    <td><?= htmlspecialchars($r['nama_user']) ?></td>
                    <td><?= $r['user_id'] ?></td>
                    <td><strong><?= $r['total_poin'] ?> Trx</strong></td>
                </tr>
                <?php endforeach; ?>
                <?php if(!$rank) echo "<tr><td colspan='4' class='text-center'>Belum ada data</td></tr>"; ?>
            </tbody>
        </table>
    </div>
</body>
</html>